/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Emios.h
\brief      This file contains all timebase definitions for Multi-Thread Scheduler
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       5/23/2008 
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/
#ifndef __EMIOS_H__
 #define __EMIOS_H__

 /*--------------------------Includes -------------------------------------------------------------*/
  #include "Derivative.h"
  
 #if (PWM_ERROR_DETECT == ON)   /* If Pwm Error Layer Enabled, validate errors */ 
   #include "Pwm_ReportError.h"
 #endif  
    
    /*------------------------- Type definitions --------------------------------------------------------------*/    
    typedef void(*Emios_CallbackType)(void);
    
    /*------------------------- Defines --------------------------------------------------------------*/  
	/* This file violates MISRA 2004 rule 11.3 because addressing memory mapped registers */
	/** emios Operation Mode */
	#define EMIOS_MCB_MODE                          ((uint8_t)0x50)
	
	/** Global eMIOS prescaler: SysClk -> Global Pres -> Local Prescaler */
	#define eMIOS_GLOBAL_PRESCALER                  ((uint8_t)128)
	/** Global Timebase enabled */
	#define eMIOS_ENABLE_GLOBAL_TIMEBASE()          (EMIOS.MCR.B.GTBE  = (uint8_t)(1))
	/** Global prescaler enabled */
	#define eMIOS_ENABLE_GLOBAL_PRESCALER()         (EMIOS.MCR.B.GPREN = (uint8_t)(1))
	/** Set global prescaler value accordingly */
	#define eMIOS_SET_GLOBAL_PRESCALER_VALUE(value) (EMIOS.MCR.B.GPRE  = (uint8_t)(value))
	/** Globally enable freeze mode */
	#define eMIOS_ENABLE_GLOBAL_FREEZE_IN_DEBUG()   (EMIOS.MCR.B.FRZ   = (uint8_t)1)
	/** Load eMIOS counter register A with a 24-bit value */
	#define eMIOS_SET_COUNT_A(channel,count)        (EMIOS.CH[channel].CADR.R = (uint16_t)(count)) 
	/** Load eMIOS counter register B with a 24-bit value */
	#define eMIOS_SET_COUNT_B(channel,count)        (EMIOS.CH[channel].CBDR.R = (uint16_t)(count))
	/** Definition of eMIOS status flag */
	#define eMIOS_STATUS_FLAG(channel)              EMIOS.CH[channel].CSR.B.FLAG 
	/** Define timer count register */
	#define eMIOS_TIMER_COUNT(channel)              EMIOS.CH[channel].CCNTR.R
	/** Local Prescaler enabled */
	#define eMIOS_ENABLE_LOCAL_PRESCALER(channel)   (EMIOS.CH[channel].CCR.B.UCPEN = (uint8_t)(1))
	/** Set local prescaler value */
	#define eMIOS_SET_PRESCALER(channel,value)      (EMIOS.CH[channel].CCR.B.UCPRE = (uint8_t)(value))
	/** Allow unified channel to set interrupt */
	#define eMIOS_ENABLE_CHANNEL_INTERRUPT(channel) (EMIOS.CH[channel].CCR.B.FEN   = (uint8_t)(1))           
	/** Clear counter of specified channel */
	#define eMIOS_CLEAR_COUNTER(channel)            (eMIOS_TIMER_COUNT(channel)    = (uint8_t)(0))
	/** Clear counter flag */
	#define eMIOS_CLEAR_STATUS_FLAG(channel)        (eMIOS_STATUS_FLAG(channel)    = (uint8_t)(1)) 
	/** Stop (freeze) channel registers when in debug mode */
	#define eMIOS_FREEZE_IN_DEBUG(channel)          (EMIOS.CH[channel].CCR.B.FREN  = (uint8_t)(1))
	/** Choose internal time base for channel */
	#define eMIOS_SET_INTERNAL_TIME_BASE(channel)   (EMIOS.CH[channel].CCR.B.BSL    = (uint8_t)(3))  
	/** Set edge polarity accordingly */
	#define eMIOS_SET_EDGE_POLARITY(channel,pol)    (EMIOS.CH[channel].CCR.B.EDPOL = (uint8_t)(pol))
	/** Indicator of input capture or a match event in the comparators occurred */
	#define eMIOS_MATCH_EVENT_FLAG(channel)         EMIOS.CH[channel].CSR.B.FLAG
	/* Select Modulus Counter, up counter, internal clock source */
    #define eMIOS_SET_MODULUS_UP_COUNTER(channel)   EMIOS.CH[channel].CCR.B.MODE = EMIOS_MCB_MODE
	/** emios channel assigned to generate Scheduler Timebase */
	#define SCHEDULER_EMIOS_CHANNEL                 ((uint8_t)0)
	/** Define interrupt assigned to Timer channel            */
    #define INTERRUPT_EMIOS_0                       ((uint8_t)58)
    /** Task Manager channel eMIOS prescaler                  */
    #define eMIOS_TM_LOCAL_PRESCALER                ((uint8_t)4)
    
    
/*------------------------- Function prototypes --------------------------------------------------------------*/  
  /** Scheduler Interrupt Function */
  void Emios_Scheduler_Isr(void);
  /** Set a function pointer to call after emios interrupt occurs */
  extern void vfnEmios_Set_Callback_Fnc(Emios_CallbackType Callback_Fnc);
#endif 